<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\User_Lists\Ajax_Function
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function to add a user to list
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_ajax_add_user_to_list() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Security check
    if( ! current_user_can( automatorwp_get_manager_capability() ) )
        wp_send_json_error( __( 'You are not allowed to perform this action.', 'automatorwp-users-lists' ) );

    // Setup vars
    $list_id = absint( $_REQUEST['list_id'] );
    $user_id = absint( $_REQUEST['user_id'] );

    // Check all vars
    if( $list_id === 0 )
        wp_send_json_error( __( 'Wrong list ID.', 'automatorwp-users-lists' ) );

    if( $user_id === 0 )
        wp_send_json_error( __( 'Wrong user ID.', 'automatorwp-users-lists' ) );

    $result = automatorwp_user_lists_add_user_to_list( $user_id, $list_id );

    if( ! $result ) {
        wp_send_json_error( __( 'User is already on list.', 'automatorwp-users-lists' ) );
    }

    wp_send_json_success( __( 'User added to list successfully!', 'automatorwp-users-lists' ) );

}
add_action( 'wp_ajax_automatorwp_user_lists_add_user_to_list', 'automatorwp_user_lists_ajax_add_user_to_list' );

/**
 * Ajax function to remove a user from list
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_ajax_remove_user_from_list() {
    
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Security check
    if( ! current_user_can( automatorwp_get_manager_capability() ) )
        wp_send_json_error( __( 'You are not allowed to perform this action.', 'automatorwp-users-lists' ) );

    // Setup vars
    $list_id = absint( $_REQUEST['list_id'] );
    $user_id = absint( $_REQUEST['user_id'] );

    // Check all vars
    if( $list_id === 0 )
        wp_send_json_error( __( 'Wrong list ID.', 'automatorwp-users-lists' ) );

    if( $user_id === 0 )
        wp_send_json_error( __( 'Wrong user ID.', 'automatorwp-users-lists' ) );

    $result = automatorwp_user_lists_remove_user_from_list( $user_id, $list_id );

    if( ! $result ) {
        wp_send_json_error( __( 'User is not on list anymore.', 'automatorwp-users-lists' ) );
    }

    wp_send_json_success( __( 'User removed from list successfully!', 'automatorwp-users-lists' ) );

}
add_action( 'wp_ajax_automatorwp_user_lists_remove_user_from_list', 'automatorwp_user_lists_ajax_remove_user_from_list' );

/**
 * Ajax function for selecting contents
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_ajax_get_lists() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( sanitize_text_field( $_REQUEST['q'] ) ) : '';

    $lists = automatorwp_user_lists_get_lists();
    
    $results = array();

    // Parse lists results to match select2 results
    foreach ( $lists as $list ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $list['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }

        $results[] = array(
            'id'   => $list['id'],
            'text' => $list['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_user_lists_get_lists', 'automatorwp_user_lists_ajax_get_lists' );